/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.platform;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.popcraft.chunky.platform.BukkitWorld;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.platform.util.Location;
import org.popcraft.chunky.util.Translator;

public class BukkitSender
implements Sender {
    private static final Pattern RGB_PATTERN;
    private static final boolean RGB_COLORS_SUPPORTED;
    private final CommandSender sender;

    public BukkitSender(CommandSender sender) {
        this.sender = sender;
    }

    @Override
    public boolean isPlayer() {
        return this.sender instanceof Player;
    }

    @Override
    public String getName() {
        return this.sender.getName();
    }

    @Override
    public World getWorld() {
        return new BukkitWorld((org.bukkit.World)Bukkit.getWorlds().get(0));
    }

    @Override
    public Location getLocation() {
        return new Location(this.getWorld(), 0.0, 0.0, 0.0, 0.0f, 0.0f);
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.sender.hasPermission(permission);
    }

    @Override
    public void sendMessage(String key, boolean prefixed, Object ... args) {
        this.sender.sendMessage(this.formatColored(Translator.translateKey(key, prefixed, args)));
    }

    protected String formatColored(String message) {
        Object coloredMessage = message;
        if (RGB_COLORS_SUPPORTED) {
            Matcher rgbMatcher = RGB_PATTERN.matcher(message);
            while (rgbMatcher.find()) {
                net.md_5.bungee.api.ChatColor rgbColor = net.md_5.bungee.api.ChatColor.of((String)rgbMatcher.group().substring(1));
                String messageStart = ((String)coloredMessage).substring(0, rgbMatcher.start());
                String messageEnd = ((String)coloredMessage).substring(rgbMatcher.end());
                coloredMessage = messageStart + String.valueOf(rgbColor) + messageEnd;
                rgbMatcher = RGB_PATTERN.matcher((CharSequence)coloredMessage);
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)coloredMessage);
    }

    static {
        boolean rgbSupported;
        RGB_PATTERN = Pattern.compile("&#[0-9a-fA-F]{6}");
        try {
            Class.forName("net.md_5.bungee.api.ChatColor");
            net.md_5.bungee.api.ChatColor.class.getMethod("of", String.class);
            rgbSupported = true;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            rgbSupported = false;
        }
        RGB_COLORS_SUPPORTED = rgbSupported;
    }
}

