/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.platform;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.popcraft.chunky.ChunkyBukkit;
import org.popcraft.chunky.platform.BukkitSender;
import org.popcraft.chunky.platform.BukkitWorld;
import org.popcraft.chunky.platform.Folia;
import org.popcraft.chunky.platform.Paper;
import org.popcraft.chunky.platform.Player;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.platform.util.Location;
import org.popcraft.chunky.util.Translator;

public class BukkitPlayer
extends BukkitSender
implements Player {
    private static final boolean ACTION_BAR_SUPPORTED;
    private final JavaPlugin plugin = JavaPlugin.getPlugin(ChunkyBukkit.class);
    final org.bukkit.entity.Player player;

    public BukkitPlayer(org.bukkit.entity.Player player) {
        super((CommandSender)player);
        this.player = player;
    }

    @Override
    public boolean isPlayer() {
        return true;
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public World getWorld() {
        return new BukkitWorld(this.player.getWorld());
    }

    @Override
    public Location getLocation() {
        org.bukkit.Location location = this.player.getLocation();
        return new Location(this.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    @Override
    public UUID getUUID() {
        return this.player.getUniqueId();
    }

    @Override
    public void teleport(Location location) {
        org.bukkit.World world = Bukkit.getWorld((String)location.getWorld().getName());
        org.bukkit.Location loc = new org.bukkit.Location(world, location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        Entity vehicle = this.player.getVehicle();
        if (vehicle == null) {
            this.teleportAsync((Entity)this.player, loc);
        } else if (Paper.isPaper() && this.player.getWorld().equals((Object)loc.getWorld())) {
            Paper.teleportAsyncWithPassengers(vehicle, loc);
        } else if (Folia.isFolia() && !Folia.isTickThread(this.player.getLocation())) {
            Folia.schedule((Plugin)this.plugin, (Entity)this.player, () -> this.teleport(location), 1L);
        } else {
            List passengers = vehicle.getPassengers();
            if (Folia.isFolia()) {
                Folia.schedule((Plugin)this.plugin, vehicle, () -> ((Entity)vehicle).eject(), 1L);
            } else {
                vehicle.eject();
            }
            this.teleportAsync((Entity)this.player, loc).thenAcceptAsync(ignored -> {
                this.teleportAsync(vehicle, loc);
                for (Entity passenger : passengers) {
                    this.teleportAsync(passenger, loc);
                    if (passenger instanceof org.bukkit.entity.Player) {
                        org.bukkit.entity.Player playerPassenger = (org.bukkit.entity.Player)passenger;
                        playerPassenger.hideEntity((Plugin)this.plugin, vehicle);
                        playerPassenger.showEntity((Plugin)this.plugin, vehicle);
                    }
                    if (Folia.isFolia()) {
                        Folia.schedule((Plugin)this.plugin, vehicle, () -> vehicle.addPassenger(passenger), 1L);
                        continue;
                    }
                    vehicle.addPassenger(passenger);
                }
            }, command -> {
                if (Folia.isFolia()) {
                    Folia.schedule((Plugin)this.plugin, (Entity)this.player, command, 1L);
                } else {
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, command, 1L);
                }
            });
        }
    }

    private CompletableFuture<Boolean> teleportAsync(Entity entity, org.bukkit.Location location) {
        if (Paper.isPaper()) {
            return Paper.teleportAsync(entity, location);
        }
        return CompletableFuture.completedFuture(entity.teleport(location));
    }

    @Override
    public void sendActionBar(String key) {
        if (ACTION_BAR_SUPPORTED) {
            String message = this.formatColored(Translator.translateKey(key, false, new Object[0]));
            this.player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
        } else {
            this.sendMessage(key, new Object[0]);
        }
    }

    static {
        boolean barSupported;
        try {
            org.bukkit.entity.Player.class.getMethod("spigot", new Class[0]);
            barSupported = true;
        }
        catch (NoSuchMethodException e) {
            barSupported = false;
        }
        ACTION_BAR_SUPPORTED = barSupported;
    }
}

