/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.popcraft.chunky.nbt.Tag;

public class DoubleTag
extends Tag {
    private double value;

    protected DoubleTag(String name) {
        super(name);
    }

    public DoubleTag(String name, double value) {
        super(name);
        this.value = value;
    }

    @Override
    public void read(DataInput input) throws IOException {
        this.value = input.readDouble();
    }

    @Override
    public void skip(DataInput input) throws IOException {
        input.skipBytes(8);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        output.writeDouble(this.value);
    }

    @Override
    public Tag search(DataInput input, byte type, String name) throws IOException {
        this.skip(input);
        return null;
    }

    @Override
    public byte type() {
        return 6;
    }

    @Override
    public String typeName() {
        return "TAG_Double";
    }

    @Override
    public String print(int level) {
        return "%s%s('%s'): %f".formatted(" ".repeat(level * 2), this.typeName(), this.name, this.value);
    }

    public double value() {
        return this.value;
    }

    public void value(double value) {
        this.value = value;
    }
}

