/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.utility;

import java.io.InputStreamReader;
import java.io.Reader;
import net.coreprotect.CoreProtect;
import net.coreprotect.config.Config;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.language.Phrase;
import net.coreprotect.thread.NetworkHandler;
import net.coreprotect.utility.Chat;
import net.coreprotect.utility.StringUtils;
import net.coreprotect.worldedit.CoreProtectEditSessionEvent;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class VersionUtils {
    private VersionUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String getPluginVersion() {
        String version = CoreProtect.getInstance().getDescription().getVersion();
        if (version.contains("-")) {
            version = version.split("-")[0];
        }
        return version;
    }

    public static Integer[] getInternalPluginVersion() {
        int major = 2;
        int minor = 0;
        int revision = 0;
        String pluginVersion = VersionUtils.getPluginVersion();
        if (pluginVersion.contains(".")) {
            String[] versionSplit = pluginVersion.split("\\.");
            minor = Integer.parseInt(versionSplit[0]);
            revision = Integer.parseInt(versionSplit[1]);
        } else {
            minor = Integer.parseInt(pluginVersion);
        }
        return new Integer[]{major, minor, revision};
    }

    public static String getPluginName() {
        CoreProtect instance = CoreProtect.getInstance();
        if (instance == null) {
            return "CoreProtect";
        }
        if (instance.getDescription() == null) {
            return "CoreProtect";
        }
        Object name = instance.getDescription().getName();
        String branch = ConfigHandler.EDITION_BRANCH;
        if (branch.startsWith("-edge")) {
            name = (String)name + " " + branch.substring(1, 2).toUpperCase() + branch.substring(2, 5);
        } else if (VersionUtils.isCommunityEdition()) {
            name = (String)name + " Community Edition";
        }
        return name;
    }

    public static boolean isSpigot() {
        try {
            Class.forName("org.spigotmc.SpigotConfig");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isPaper() {
        try {
            Class.forName("com.destroystokyo.paper.PaperConfig");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isCommunityEdition() {
        return !VersionUtils.isBranch("edge") && !VersionUtils.isBranch("coreprotect") && !VersionUtils.validDonationKey();
    }

    public static boolean isBranch(String branch) {
        return ConfigHandler.EDITION_BRANCH.contains("-" + branch);
    }

    public static boolean validDonationKey() {
        return NetworkHandler.donationKey() != null;
    }

    public static String getBranch() {
        Object branch = "";
        try {
            CoreProtect instance = CoreProtect.getInstance();
            if (instance == null) {
                return "";
            }
            InputStreamReader reader = new InputStreamReader(((Object)((Object)instance)).getClass().getResourceAsStream("/plugin.yml"));
            branch = YamlConfiguration.loadConfiguration((Reader)reader).getString("branch");
            reader.close();
            if (branch == null || ((String)branch).equals("${project.branch}")) {
                branch = "";
            }
            if (((String)branch).startsWith("-")) {
                branch = ((String)branch).substring(1);
            }
            if (((String)branch).length() > 0) {
                branch = "-" + (String)branch;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return branch;
    }

    public static boolean newVersion(Integer[] oldVersion, Integer[] currentVersion) {
        if (oldVersion[0] < currentVersion[0]) {
            return true;
        }
        if (oldVersion[0].equals(currentVersion[0]) && oldVersion[1] < currentVersion[1]) {
            return true;
        }
        if (oldVersion.length < 3 && currentVersion.length >= 3 && oldVersion[0].equals(currentVersion[0]) && oldVersion[1].equals(currentVersion[1]) && 0 < currentVersion[2]) {
            return true;
        }
        return oldVersion.length >= 3 && currentVersion.length >= 3 && oldVersion[0].equals(currentVersion[0]) && oldVersion[1].equals(currentVersion[1]) && oldVersion[2] < currentVersion[2];
    }

    public static boolean newVersion(Integer[] oldVersion, String currentVersion) {
        String[] currentVersionSplit = currentVersion.split("\\.");
        return VersionUtils.newVersion(oldVersion, StringUtils.convertArray(currentVersionSplit));
    }

    public static boolean newVersion(String oldVersion, Integer[] currentVersion) {
        String[] oldVersionSplit = oldVersion.split("\\.");
        return VersionUtils.newVersion(StringUtils.convertArray(oldVersionSplit), currentVersion);
    }

    public static boolean newVersion(String oldVersion, String currentVersion) {
        if (!oldVersion.contains(".") || !currentVersion.contains(".")) {
            return false;
        }
        String[] oldVersionSplit = oldVersion.split("\\.");
        String[] currentVersionSplit = currentVersion.split("\\.");
        return VersionUtils.newVersion(StringUtils.convertArray(oldVersionSplit), StringUtils.convertArray(currentVersionSplit));
    }

    public static void loadWorldEdit() {
        try {
            boolean validVersion = true;
            String version = Bukkit.getServer().getPluginManager().getPlugin("WorldEdit").getDescription().getVersion();
            if (version.contains(";") || version.contains("+")) {
                long value;
                if (version.contains("-beta-")) {
                    version = version.split(";")[0];
                    long value2 = Long.parseLong((version = version.split("-beta-")[1]).replaceAll("[^0-9]", ""));
                    if (value2 < 6L) {
                        validVersion = false;
                    }
                } else if ((version = version.contains("+") ? version.split("\\+")[1] : version.split(";")[1]).contains("-") && (value = Long.parseLong(version.split("-")[0].replaceAll("[^0-9]", ""))) > 0L && value < 4268L) {
                    validVersion = false;
                }
            } else if (version.contains(".")) {
                String[] worldEditVersion = version.split("-|\\.");
                if (worldEditVersion.length >= 2) {
                    worldEditVersion[0] = worldEditVersion[0].replaceAll("[^0-9]", "");
                    worldEditVersion[1] = worldEditVersion[1].replaceAll("[^0-9]", "");
                    if (worldEditVersion[0].length() == 0 || worldEditVersion[1].length() == 0 || VersionUtils.newVersion(worldEditVersion[0] + "." + worldEditVersion[1], "7.1")) {
                        validVersion = false;
                    }
                }
            } else if (version.equals("unspecified")) {
                validVersion = false;
                Plugin fawe = Bukkit.getServer().getPluginManager().getPlugin("FastAsyncWorldEdit");
                if (fawe != null) {
                    String apiVersion = Bukkit.getServer().getPluginManager().getPlugin("WorldEdit").getDescription().getAPIVersion();
                    String faweVersion = fawe.getDescription().getVersion();
                    double apiDouble = Double.parseDouble(apiVersion);
                    double faweDouble = Double.parseDouble(faweVersion);
                    if (apiDouble >= 1.13 && faweDouble >= 1.0) {
                        validVersion = true;
                    }
                }
            } else {
                validVersion = false;
            }
            if (validVersion) {
                CoreProtectEditSessionEvent.register();
            } else {
                Chat.console(Phrase.build(Phrase.INTEGRATION_VERSION, "WorldEdit"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void unloadWorldEdit() {
        try {
            CoreProtectEditSessionEvent.unregister();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean checkWorldEdit() {
        boolean result = false;
        for (World world : Bukkit.getServer().getWorlds()) {
            if (!Config.getConfig((World)world).WORLDEDIT) continue;
            result = true;
            break;
        }
        return result;
    }
}

