/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.utility;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;

public class SystemUtils {
    private static boolean testMode = Boolean.getBoolean("net.coreprotect.test");
    private static String processorInfo = null;
    private static boolean log4jInitialized = false;
    private static Double appleProcessorSpeed = null;

    private SystemUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void setTestMode(boolean enabled) {
        testMode = enabled;
        if (enabled) {
            processorInfo = "Test Processor";
        }
    }

    public static boolean isAppleSilicon() {
        String osName = System.getProperty("os.name", "").toLowerCase();
        String osArch = System.getProperty("os.arch", "").toLowerCase();
        return osName.contains("mac") && (osArch.contains("aarch64") || osArch.contains("arm"));
    }

    public static Double getAppleSiliconSpeed() {
        String modelName;
        block19: {
            if (appleProcessorSpeed != null) {
                return appleProcessorSpeed;
            }
            if (testMode) {
                return 3.2;
            }
            modelName = SystemUtils.getProcessorModel();
            if (modelName != null && modelName.contains("GHz")) {
                try {
                    Pattern pattern = Pattern.compile("(\\d+\\.\\d+)GHz");
                    Matcher matcher = pattern.matcher(modelName);
                    if (matcher.find()) {
                        appleProcessorSpeed = Double.parseDouble(matcher.group(1));
                        return appleProcessorSpeed;
                    }
                }
                catch (Exception pattern) {
                    // empty catch block
                }
            }
            try {
                ProcessBuilder pb = new ProcessBuilder("sysctl", "-n", "machdep.cpu.brand_string");
                Process process = pb.start();
                if (!process.waitFor(500L, TimeUnit.MILLISECONDS)) break block19;
                String appleChipInfo = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    appleChipInfo = reader.readLine();
                }
                if (appleChipInfo != null) {
                    if (appleChipInfo.contains("M1")) {
                        return SystemUtils.getMSeriesSpeed("M1", appleChipInfo);
                    }
                    if (appleChipInfo.contains("M2")) {
                        return SystemUtils.getMSeriesSpeed("M2", appleChipInfo);
                    }
                    if (appleChipInfo.contains("M3")) {
                        return SystemUtils.getMSeriesSpeed("M3", appleChipInfo);
                    }
                    if (appleChipInfo.contains("M4")) {
                        return SystemUtils.getMSeriesSpeed("M4", appleChipInfo);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (modelName != null) {
            appleProcessorSpeed = modelName.contains("M1") ? Double.valueOf(3.2) : (modelName.contains("M2") ? Double.valueOf(3.7) : (modelName.contains("M3") ? Double.valueOf(4.05) : (modelName.contains("M4") ? Double.valueOf(4.5) : Double.valueOf(3.0))));
            return appleProcessorSpeed;
        }
        return 3.2;
    }

    private static Double getMSeriesSpeed(String series, String chipInfo) {
        switch (series) {
            case "M1": {
                if (chipInfo.contains("Pro") || chipInfo.contains("Max") || chipInfo.contains("Ultra")) {
                    appleProcessorSpeed = 3.23;
                    break;
                }
                appleProcessorSpeed = 3.2;
                break;
            }
            case "M2": {
                if (chipInfo.contains("Pro") || chipInfo.contains("Max") || chipInfo.contains("Ultra")) {
                    appleProcessorSpeed = 3.7;
                    break;
                }
                appleProcessorSpeed = 3.5;
                break;
            }
            case "M3": {
                if (chipInfo.contains("Pro") || chipInfo.contains("Max")) {
                    appleProcessorSpeed = 4.05;
                    break;
                }
                appleProcessorSpeed = 4.0;
                break;
            }
            case "M4": {
                if (chipInfo.contains("Max")) {
                    appleProcessorSpeed = 4.5;
                    break;
                }
                if (chipInfo.contains("Pro")) {
                    appleProcessorSpeed = 4.5;
                    break;
                }
                appleProcessorSpeed = 4.3;
                break;
            }
            default: {
                appleProcessorSpeed = 3.2;
            }
        }
        return appleProcessorSpeed;
    }

    private static String getProcessorModel() {
        block7: {
            String string;
            ProcessBuilder pb = new ProcessBuilder("sysctl", "-n", "machdep.cpu.brand_string");
            Process process = pb.start();
            if (!process.waitFor(500L, TimeUnit.MILLISECONDS)) break block7;
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            try {
                string = reader.readLine();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            reader.close();
            return string;
        }
        return null;
    }

    public static CentralProcessor getProcessorInfo() {
        if (testMode || SystemUtils.isLog4jDisabled()) {
            return null;
        }
        CentralProcessor result = null;
        try {
            Class.forName("com.sun.jna.Platform");
            if (System.getProperty("os.name").startsWith("Windows") && !System.getProperty("sun.arch.data.model").equals("64")) {
                Class.forName("com.sun.jna.platform.win32.Win32Exception");
            } else if (System.getProperty("os.name").toLowerCase().contains("android") || System.getProperty("java.runtime.name").toLowerCase().contains("android")) {
                return null;
            }
            try {
                if (!log4jInitialized) {
                    Configurator.setLevel((String)"oshi.hardware.common.AbstractCentralProcessor", (Level)Level.OFF);
                    log4jInitialized = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            SystemInfo systemInfo = new SystemInfo();
            result = systemInfo.getHardware().getProcessor();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String getProcessorInfoString() {
        if (processorInfo != null) {
            return processorInfo;
        }
        CentralProcessor processor = SystemUtils.getProcessorInfo();
        if (processor != null) {
            processorInfo = processor.getProcessorIdentifier().getName();
            return processorInfo;
        }
        return "Unknown";
    }

    private static boolean isLog4jDisabled() {
        return Boolean.getBoolean("log4j2.disable") || Boolean.getBoolean("net.coreprotect.disable.log4j") || System.getProperty("log4j.configurationFile", "").contains("no-log4j2.xml");
    }
}

