/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.utility;

import java.util.Locale;
import java.util.Set;
import net.coreprotect.bukkit.BukkitAdapter;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.consumer.Queue;
import org.bukkit.Material;

public class MaterialUtils
extends Queue {
    private static final String NAMESPACE = "minecraft:";

    private MaterialUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static int getBlockId(Material material) {
        if (material == null) {
            material = Material.AIR;
        }
        return MaterialUtils.getBlockId(material.name(), true);
    }

    public static int getBlockId(String name, boolean internal) {
        int id = -1;
        if (!((String)(name = ((String)name).toLowerCase(Locale.ROOT).trim())).contains(":")) {
            name = NAMESPACE + (String)name;
        }
        if (ConfigHandler.materials.get(name) != null) {
            id = ConfigHandler.materials.get(name);
        } else if (internal) {
            id = ConfigHandler.reloadAndGetId(ConfigHandler.CacheType.MATERIALS, (String)name);
            if (id != -1) {
                return id;
            }
            int mid = ConfigHandler.materialId + 1;
            ConfigHandler.materials.put((String)name, mid);
            ConfigHandler.materialsReversed.put(mid, (String)name);
            ConfigHandler.materialId = mid;
            Queue.queueMaterialInsert(mid, (String)name);
            id = ConfigHandler.materials.get(name);
        }
        return id;
    }

    public static int getBlockdataId(String data, boolean internal) {
        int id = -1;
        if (ConfigHandler.blockdata.get(data = data.toLowerCase(Locale.ROOT).trim()) != null) {
            id = ConfigHandler.blockdata.get(data);
        } else if (internal) {
            id = ConfigHandler.reloadAndGetId(ConfigHandler.CacheType.BLOCKDATA, data);
            if (id != -1) {
                return id;
            }
            int bid = ConfigHandler.blockdataId + 1;
            ConfigHandler.blockdata.put(data, bid);
            ConfigHandler.blockdataReversed.put(bid, data);
            ConfigHandler.blockdataId = bid;
            Queue.queueBlockDataInsert(bid, data);
            id = ConfigHandler.blockdata.get(data);
        }
        return id;
    }

    public static String getBlockDataString(int id) {
        String blockdata = "";
        if (ConfigHandler.blockdataReversed.get(id) != null) {
            blockdata = ConfigHandler.blockdataReversed.get(id);
        }
        return blockdata;
    }

    public static String getBlockName(int id) {
        String name = "";
        if (ConfigHandler.materialsReversed.get(id) != null) {
            name = ConfigHandler.materialsReversed.get(id);
        }
        return name;
    }

    public static String getBlockNameShort(int id) {
        String name = MaterialUtils.getBlockName(id);
        if (name.contains(":")) {
            name = name.split(":")[1];
        }
        return name;
    }

    public static Material getType(int id) {
        Material material = null;
        if (ConfigHandler.materialsReversed.get(id) != null && id > 0) {
            String name = ConfigHandler.materialsReversed.get(id).toUpperCase(Locale.ROOT);
            if (name.contains(NAMESPACE.toUpperCase(Locale.ROOT))) {
                name = name.split(":")[1];
            }
            if ((material = Material.getMaterial((String)(name = BukkitAdapter.ADAPTER.parseLegacyName(name)))) == null) {
                material = Material.getMaterial((String)name, (boolean)true);
            }
        }
        return material;
    }

    public static Material getType(String name) {
        Material material = null;
        if (!(name = name.toUpperCase(Locale.ROOT).trim()).startsWith("#")) {
            if (name.contains(NAMESPACE.toUpperCase(Locale.ROOT))) {
                name = name.split(":")[1];
            }
            name = BukkitAdapter.ADAPTER.parseLegacyName(name);
            material = Material.matchMaterial((String)name);
        }
        return material;
    }

    public static int getArtId(String name, boolean internal) {
        int id = -1;
        if (ConfigHandler.art.get(name = name.toLowerCase(Locale.ROOT).trim()) != null) {
            id = ConfigHandler.art.get(name);
        } else if (internal) {
            id = ConfigHandler.reloadAndGetId(ConfigHandler.CacheType.ART, name);
            if (id != -1) {
                return id;
            }
            int artID = ConfigHandler.artId + 1;
            ConfigHandler.art.put(name, artID);
            ConfigHandler.artReversed.put(artID, name);
            ConfigHandler.artId = artID;
            Queue.queueArtInsert(artID, name);
            id = ConfigHandler.art.get(name);
        }
        return id;
    }

    public static String getArtName(int id) {
        String artname = "";
        if (ConfigHandler.artReversed.get(id) != null) {
            artname = ConfigHandler.artReversed.get(id);
        }
        return artname;
    }

    public static int getMaterialId(Material material) {
        return MaterialUtils.getBlockId(material.name(), true);
    }

    public static boolean listContains(Set<Material> list, Material value) {
        boolean result = false;
        for (Material list_value : list) {
            if (!list_value.equals((Object)value)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static int rolledBack(int rolledBack, boolean isInventory) {
        switch (rolledBack) {
            case 1: {
                return isInventory ? 0 : 1;
            }
            case 2: {
                return isInventory ? 1 : 0;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    public static int toggleRolledBack(int rolledBack, boolean isInventory) {
        switch (rolledBack) {
            case 1: {
                return isInventory ? 3 : 0;
            }
            case 2: {
                return isInventory ? 0 : 3;
            }
            case 3: {
                return isInventory ? 1 : 2;
            }
        }
        return isInventory ? 2 : 1;
    }
}

