/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.coreprotect.config.Config;
import net.coreprotect.consumer.Queue;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.StructureGrowEvent;

public final class StructureGrowListener
extends Queue
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    protected void onStructureGrow(StructureGrowEvent event) {
        TreeType treeType = event.getSpecies();
        String user = "#tree";
        boolean tree = true;
        if (treeType == null || event.isFromBonemeal()) {
            return;
        }
        List blocks = event.getBlocks();
        if (blocks.size() <= 4) {
            for (BlockState block : blocks) {
                if (!Tag.SAPLINGS.isTagged((Keyed)block.getType()) && !block.getType().equals((Object)Material.BROWN_MUSHROOM) && !block.getType().equals((Object)Material.RED_MUSHROOM)) continue;
                return;
            }
        }
        if (treeType.name().toLowerCase(Locale.ROOT).contains("mushroom")) {
            user = "#mushroom";
            tree = false;
        }
        if (!event.isCancelled()) {
            World world = event.getWorld();
            if (tree && Config.getConfig((World)world).TREE_GROWTH || !tree && Config.getConfig((World)world).MUSHROOM_GROWTH) {
                Player player = event.getPlayer();
                Location location = event.getLocation();
                if (player != null) {
                    user = player.getName();
                }
                ArrayList<BlockState> structureBlocks = new ArrayList<BlockState>(blocks);
                structureBlocks.removeIf(replacedBlock -> replacedBlock.getY() > location.getBlockY());
                for (int i = 0; i < structureBlocks.size(); ++i) {
                    BlockState replacedBlock2 = (BlockState)structureBlocks.get(i);
                    structureBlocks.set(i, replacedBlock2.getBlock().getState());
                }
                int replacedListSize = structureBlocks.size();
                structureBlocks.addAll(blocks);
                Queue.queueStructureGrow(user, world.getBlockAt(location).getState(), structureBlocks, replacedListSize);
            }
        }
    }
}

