/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener.player;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import net.coreprotect.CoreProtect;
import net.coreprotect.bukkit.BukkitAdapter;
import net.coreprotect.config.Config;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.consumer.Queue;
import net.coreprotect.listener.player.HopperPullListener;
import net.coreprotect.listener.player.HopperPushListener;
import net.coreprotect.model.BlockGroup;
import net.coreprotect.paper.PaperAdapter;
import net.coreprotect.thread.Scheduler;
import net.coreprotect.utility.ItemUtils;
import net.coreprotect.utility.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import us.lynuxcraft.deadsilenceiv.advancedchests.AdvancedChestsAPI;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.AdvancedChest;

public final class InventoryChangeListener
extends Queue
implements Listener {
    protected static AtomicLong tasksStarted = new AtomicLong();
    protected static AtomicLong tasksCompleted = new AtomicLong();
    private static ConcurrentHashMap<String, Boolean> inventoryProcessing = new ConcurrentHashMap();
    private static final Object taskCompletionLock = new Object();
    private static final long TASK_WAIT_MAX_MS = 50L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void checkTasks(long taskStarted) {
        try {
            if (taskStarted <= 1L || tasksCompleted.get() >= taskStarted - 1L) {
                tasksCompleted.set(taskStarted);
                return;
            }
            if (tasksCompleted.compareAndSet(taskStarted - 1L, taskStarted)) {
                return;
            }
            Object object = taskCompletionLock;
            synchronized (object) {
                if (tasksCompleted.get() < taskStarted - 1L) {
                    taskCompletionLock.wait(50L);
                }
                tasksCompleted.set(taskStarted);
                taskCompletionLock.notifyAll();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean inventoryTransaction(String user, Location location, ItemStack[] inventoryData) {
        BlockState blockState;
        Material type;
        if (user != null && location != null && user.length() > 0 && BlockGroup.CONTAINERS.contains(type = (blockState = location.getBlock().getState()).getType()) && blockState instanceof InventoryHolder) {
            InventoryHolder inventoryHolder = (InventoryHolder)blockState;
            return InventoryChangeListener.onInventoryInteract(user, inventoryHolder.getInventory(), inventoryData, null, location, false);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean onInventoryInteract(String user, Inventory inventory, ItemStack[] inventoryData, Material containerType, Location location, boolean aSync) {
        List<ItemStack[]> list;
        if (inventory == null || location == null) return false;
        World world = location.getWorld();
        if (!Config.getConfig((World)world).ITEM_TRANSACTIONS) return false;
        Material type = Material.CHEST;
        Location playerLocation = null;
        if (aSync) {
            playerLocation = location;
            if (containerType != null) {
                type = containerType;
            }
        } else {
            BlockState state;
            InventoryHolder inventoryHolder = inventory.getHolder();
            if (inventoryHolder == null) {
                if (!CoreProtect.getInstance().isAdvancedChestsEnabled()) return false;
                AdvancedChest advancedChest = AdvancedChestsAPI.getInventoryManager().getAdvancedChest(inventory);
                if (advancedChest == null) return false;
                playerLocation = advancedChest.getLocation();
            }
            if (inventoryHolder instanceof BlockState) {
                state = (BlockState)inventoryHolder;
                type = state.getType();
                if (BlockGroup.CONTAINERS.contains(type)) {
                    playerLocation = state.getLocation();
                }
            } else if (inventoryHolder instanceof DoubleChest) {
                state = (DoubleChest)inventoryHolder;
                playerLocation = state.getLocation();
            }
        }
        if (playerLocation == null) return false;
        if (inventoryData == null) {
            inventoryData = inventory.getContents();
        }
        int x = playerLocation.getBlockX();
        int y = playerLocation.getBlockY();
        int z = playerLocation.getBlockZ();
        String transactingChestId = playerLocation.getWorld().getUID().toString() + "." + x + "." + y + "." + z;
        String loggingChestId = user.toLowerCase(Locale.ROOT) + "." + x + "." + y + "." + z;
        for (String loggingChestIdViewer : ConfigHandler.oldContainer.keySet()) {
            List<Object> transactingChestList;
            if (loggingChestIdViewer.equals(loggingChestId) || !loggingChestIdViewer.endsWith("." + x + "." + y + "." + z) || ConfigHandler.oldContainer.get(loggingChestIdViewer) == null) continue;
            int sizeOld = ConfigHandler.oldContainer.get(loggingChestIdViewer).size();
            ConfigHandler.forceContainer.computeIfAbsent(loggingChestIdViewer, k -> new ArrayList());
            list = ConfigHandler.forceContainer.get(loggingChestIdViewer);
            if (list == null || list.size() >= sizeOld) continue;
            ItemStack[] containerState = ItemUtils.getContainerState(inventoryData);
            List<Object> transactingChest = ConfigHandler.transactingChest.get(transactingChestId);
            if (transactingChest != null && !(transactingChestList = Collections.synchronizedList(new ArrayList<Object>(transactingChest))).isEmpty()) {
                ItemStack[] newState = new ItemStack[containerState.length + transactingChestList.size()];
                int count = 0;
                for (int j = 0; j < containerState.length; ++j) {
                    newState[j] = containerState[j];
                    ++count;
                }
                block2: for (Object item : transactingChestList) {
                    ItemStack addItem = null;
                    ItemStack removeItem = null;
                    if (item instanceof ItemStack) {
                        addItem = (ItemStack)item;
                    } else {
                        addItem = ((ItemStack[])item)[0];
                        removeItem = ((ItemStack[])item)[1];
                    }
                    if (addItem != null) {
                        newState[count] = addItem;
                        ++count;
                    }
                    if (removeItem == null) continue;
                    for (ItemStack check : newState) {
                        if (check == null || !check.isSimilar(removeItem)) continue;
                        check.setAmount(check.getAmount() - 1);
                        continue block2;
                    }
                }
                containerState = newState;
            }
            InventoryChangeListener.modifyForceContainer(loggingChestIdViewer, containerState);
        }
        int chestId = InventoryChangeListener.getChestId(loggingChestId);
        if (chestId > 0) {
            List<ItemStack[]> forceList = ConfigHandler.forceContainer.get(loggingChestId);
            if (forceList != null) {
                int forceSize = forceList.size();
                list = ConfigHandler.oldContainer.get(loggingChestId);
                if (list != null && list.size() <= forceSize) {
                    list.add(ItemUtils.getContainerState(inventoryData));
                    ConfigHandler.oldContainer.put(loggingChestId, list);
                }
            }
        } else {
            ArrayList<ItemStack[]> list2 = new ArrayList<ItemStack[]>();
            list2.add(ItemUtils.getContainerState(inventoryData));
            ConfigHandler.oldContainer.put(loggingChestId, list2);
        }
        ConfigHandler.transactingChest.computeIfAbsent(transactingChestId, k -> Collections.synchronizedList(new ArrayList()));
        Queue.queueContainerTransaction(user, playerLocation, type, inventory, chestId);
        return true;
    }

    static void onInventoryInteractAsync(Player player, Inventory inventory, boolean enderChest) {
        AdvancedChest chest;
        if (inventory == null) {
            return;
        }
        Location location = null;
        try {
            location = inventory.getLocation();
        }
        catch (Exception e) {
            return;
        }
        if (location == null && !CoreProtect.getInstance().isAdvancedChestsEnabled()) {
            return;
        }
        if (CoreProtect.getInstance().isAdvancedChestsEnabled() && (chest = AdvancedChestsAPI.getInventoryManager().getAdvancedChest(inventory)) != null) {
            location = chest.getLocation();
        }
        if (location == null) {
            return;
        }
        if (!Config.getConfig((World)location.getWorld()).ITEM_TRANSACTIONS) {
            return;
        }
        Location inventoryLocation = location;
        ItemStack[] containerState = ItemUtils.getContainerState(inventory.getContents());
        String loggingChestId = player.getName() + "." + location.getBlockX() + "." + location.getBlockY() + "." + location.getBlockZ();
        Boolean lastTransaction = inventoryProcessing.get(loggingChestId);
        if (lastTransaction != null) {
            return;
        }
        inventoryProcessing.put(loggingChestId, true);
        long taskStarted = tasksStarted.incrementAndGet();
        Scheduler.runTaskAsynchronously(CoreProtect.getInstance(), () -> {
            try {
                Material containerType = !enderChest ? null : Material.ENDER_CHEST;
                InventoryChangeListener.checkTasks(taskStarted);
                inventoryProcessing.remove(loggingChestId);
                InventoryChangeListener.onInventoryInteract(player.getName(), inventory, containerState, containerType, inventoryLocation, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private boolean checkAnvilOperation(InventoryClickEvent event) {
        if (event.getInventory().getType() != InventoryType.ANVIL) {
            return false;
        }
        if (event.getRawSlot() != 2) {
            return false;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack resultItem = event.getCurrentItem();
        if (resultItem == null || resultItem.getType() == Material.AIR) {
            return false;
        }
        ItemStack firstItem = event.getInventory().getItem(0);
        ItemStack secondItem = event.getInventory().getItem(1);
        if (firstItem == null || secondItem == null) {
            return false;
        }
        Location location = player.getLocation();
        String loggingItemId = player.getName().toLowerCase(Locale.ROOT) + "." + location.getBlockX() + "." + location.getBlockY() + "." + location.getBlockZ();
        int itemId = InventoryChangeListener.getItemId(loggingItemId);
        ArrayList<ItemStack> removedItems = new ArrayList<ItemStack>();
        removedItems.add(firstItem.clone());
        removedItems.add(secondItem.clone());
        ConfigHandler.itemsDestroy.put(loggingItemId, removedItems);
        ArrayList<ItemStack> createdItems = new ArrayList<ItemStack>();
        createdItems.add(resultItem.clone());
        ConfigHandler.itemsCreate.put(loggingItemId, createdItems);
        int time = (int)(System.currentTimeMillis() / 1000L) + 1;
        Queue.queueItemTransaction(player.getName(), location.clone(), time, 0, itemId);
        return true;
    }

    private boolean checkCrafterSlotChange(InventoryClickEvent event) {
        if (!BukkitAdapter.ADAPTER.isCrafter(event.getInventory().getType())) {
            return false;
        }
        if (event.getAction() != InventoryAction.NOTHING) {
            return false;
        }
        if (event.getRawSlot() < 0 || event.getRawSlot() > 8) {
            return false;
        }
        if (event.getClick() != ClickType.LEFT && event.getClick() != ClickType.RIGHT) {
            return false;
        }
        Player player = (Player)event.getWhoClicked();
        Inventory inventory = event.getInventory();
        Location location = null;
        try {
            location = inventory.getLocation();
        }
        catch (Exception e) {
            return false;
        }
        if (location == null) {
            return false;
        }
        Block block = location.getBlock();
        BlockState blockState = block.getState();
        Queue.queueBlockPlace(player.getName(), blockState, block.getType(), blockState, block.getType(), -1, 0, blockState.getBlockData().getAsString());
        return true;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    protected void onInventoryClick(InventoryClickEvent event) {
        Inventory inventory;
        InventoryAction inventoryAction = event.getAction();
        if (this.checkCrafterSlotChange(event)) {
            return;
        }
        if (inventoryAction == InventoryAction.NOTHING) {
            return;
        }
        if (this.checkAnvilOperation(event)) {
            return;
        }
        boolean enderChest = false;
        if (inventoryAction != InventoryAction.MOVE_TO_OTHER_INVENTORY && inventoryAction != InventoryAction.COLLECT_TO_CURSOR && inventoryAction != InventoryAction.UNKNOWN) {
            inventory = null;
            try {
                try {
                    inventory = event.getView().getInventory(event.getRawSlot());
                }
                catch (IncompatibleClassChangeError e) {
                    inventory = event.getClickedInventory();
                }
            }
            catch (Exception e) {
                return;
            }
            if (inventory == null) {
                return;
            }
            InventoryHolder inventoryHolder = inventory.getHolder();
            enderChest = inventory.equals((Object)event.getWhoClicked().getEnderChest());
            boolean advancedChest = this.isAdvancedChest(inventory);
            if (!(inventoryHolder instanceof BlockInventoryHolder || inventoryHolder instanceof DoubleChest || enderChest || advancedChest)) {
                return;
            }
            if (advancedChest && event.getSlot() > inventory.getSize() - 10) {
                return;
            }
        } else {
            inventory = event.getInventory();
            if (inventory == null) {
                return;
            }
            InventoryHolder inventoryHolder = inventory.getHolder();
            enderChest = inventory.equals((Object)event.getWhoClicked().getEnderChest());
            boolean advancedChest = this.isAdvancedChest(inventory);
            if (!(inventoryHolder instanceof BlockInventoryHolder || inventoryHolder instanceof DoubleChest || enderChest || advancedChest)) {
                return;
            }
            if (advancedChest && event.getSlot() > inventory.getSize() - 10) {
                return;
            }
        }
        Player player = (Player)event.getWhoClicked();
        InventoryChangeListener.onInventoryInteractAsync(player, event.getInventory(), enderChest);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    protected void onInventoryDragEvent(InventoryDragEvent event) {
        boolean movedItem = false;
        boolean enderChest = false;
        Inventory inventory = event.getInventory();
        InventoryHolder inventoryHolder = inventory.getHolder();
        if (inventory == null || inventoryHolder != null && inventoryHolder.equals((Object)event.getWhoClicked())) {
            return;
        }
        enderChest = inventory.equals((Object)event.getWhoClicked().getEnderChest());
        if (inventoryHolder instanceof BlockInventoryHolder || inventoryHolder instanceof DoubleChest || enderChest || this.isAdvancedChest(inventory)) {
            movedItem = true;
        }
        if (!movedItem) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        InventoryChangeListener.onInventoryInteractAsync(player, event.getInventory(), enderChest);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    protected void onInventoryMoveItemEvent(InventoryMoveItemEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Inventory sourceInventory = event.getSource();
        if (sourceInventory == null) {
            return;
        }
        Location location = sourceInventory.getLocation();
        if (location == null) {
            return;
        }
        boolean hopperTransactions = Config.getConfig((World)location.getWorld()).HOPPER_TRANSACTIONS;
        if (!hopperTransactions && !Config.getConfig((World)location.getWorld()).ITEM_TRANSACTIONS) {
            return;
        }
        InventoryHolder sourceHolder = PaperAdapter.ADAPTER.getHolder(sourceInventory, false);
        if (sourceHolder == null) {
            return;
        }
        InventoryHolder destinationHolder = PaperAdapter.ADAPTER.getHolder(event.getDestination(), false);
        if (destinationHolder == null) {
            return;
        }
        if (hopperTransactions) {
            if (Validate.isHopper(destinationHolder) && Validate.isContainer(sourceHolder) && !Validate.isHopper(sourceHolder)) {
                HopperPullListener.processHopperPull(location, "#hopper", sourceHolder, destinationHolder, event.getItem());
            } else if (Validate.isHopper(sourceHolder) && Validate.isContainer(destinationHolder) && !Validate.isHopper(destinationHolder)) {
                HopperPushListener.processHopperPush(location, "#hopper", sourceHolder, destinationHolder, event.getItem());
            } else if (Validate.isDropper(sourceHolder) && Validate.isContainer(destinationHolder)) {
                HopperPullListener.processHopperPull(location, "#dropper", sourceHolder, destinationHolder, event.getItem());
                if (!Validate.isHopper(destinationHolder)) {
                    HopperPushListener.processHopperPush(location, "#dropper", sourceHolder, destinationHolder, event.getItem());
                }
            }
            return;
        }
        if (destinationHolder instanceof Player || !(sourceHolder instanceof BlockInventoryHolder) && !(sourceHolder instanceof DoubleChest)) {
            return;
        }
        List<Object> list = ConfigHandler.transactingChest.get(location.getWorld().getUID().toString() + "." + location.getBlockX() + "." + location.getBlockY() + "." + location.getBlockZ());
        if (list == null) {
            return;
        }
        HopperPullListener.processHopperPull(location, "#hopper", sourceHolder, destinationHolder, event.getItem());
    }

    private boolean isAdvancedChest(Inventory inventory) {
        return CoreProtect.getInstance().isAdvancedChestsEnabled() && AdvancedChestsAPI.getInventoryManager().getAdvancedChest(inventory) != null;
    }
}

