/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener.entity;

import net.coreprotect.bukkit.BukkitAdapter;
import net.coreprotect.config.Config;
import net.coreprotect.consumer.Queue;
import net.coreprotect.database.Lookup;
import net.coreprotect.listener.player.PlayerInteractEntityListener;
import net.coreprotect.utility.MaterialUtils;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Painting;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.inventory.ItemStack;

public final class HangingBreakListener
extends Queue
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    protected void onHangingBreak(HangingBreakEvent event) {
        HangingBreakEvent.RemoveCause cause = event.getCause();
        Hanging entity = event.getEntity();
        Block blockEvent = event.getEntity().getLocation().getBlock();
        if ((entity instanceof ItemFrame || entity instanceof Painting) && (cause.equals((Object)HangingBreakEvent.RemoveCause.EXPLOSION) || cause.equals((Object)HangingBreakEvent.RemoveCause.PHYSICS) || cause.equals((Object)HangingBreakEvent.RemoveCause.OBSTRUCTION))) {
            Material material;
            String causeName = "#explosion";
            Block attachedBlock = null;
            boolean logDrops = false;
            if (cause.equals((Object)HangingBreakEvent.RemoveCause.PHYSICS)) {
                causeName = "#physics";
            } else if (cause.equals((Object)HangingBreakEvent.RemoveCause.OBSTRUCTION)) {
                causeName = "#obstruction";
            }
            if (!cause.equals((Object)HangingBreakEvent.RemoveCause.EXPLOSION)) {
                Hanging hangingEntity = entity;
                BlockFace attached = hangingEntity.getAttachedFace();
                attachedBlock = hangingEntity.getLocation().getBlock().getRelative(attached);
                String removed = Lookup.whoRemovedCache(attachedBlock.getState());
                if (removed.length() > 0) {
                    causeName = removed;
                    logDrops = true;
                }
            }
            String blockData = null;
            int itemData = 0;
            if (entity instanceof ItemFrame) {
                material = BukkitAdapter.ADAPTER.getFrameType((Entity)entity);
                ItemFrame itemframe = (ItemFrame)entity;
                blockData = "FACING=" + itemframe.getFacing().name();
                if (!event.isCancelled() && Config.getConfig((World)entity.getWorld()).ITEM_TRANSACTIONS && itemframe.getItem().getType() != Material.AIR) {
                    ItemStack[] oldState = new ItemStack[]{itemframe.getItem().clone()};
                    ItemStack[] newState = new ItemStack[]{new ItemStack(Material.AIR)};
                    PlayerInteractEntityListener.queueContainerSpecifiedItems(causeName, Material.ITEM_FRAME, new Object[]{oldState, newState, itemframe.getFacing()}, itemframe.getLocation(), logDrops);
                }
            } else {
                material = Material.PAINTING;
                Painting painting = (Painting)entity;
                blockData = "FACING=" + painting.getFacing().name();
                try {
                    itemData = MaterialUtils.getArtId(painting.getArt().toString(), true);
                }
                catch (IncompatibleClassChangeError incompatibleClassChangeError) {
                    // empty catch block
                }
            }
            if (!event.isCancelled() && Config.getConfig((World)blockEvent.getWorld()).NATURAL_BREAK) {
                Queue.queueNaturalBlockBreak(causeName, blockEvent.getState(), attachedBlock, material, blockData, itemData);
            }
        }
    }
}

