/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener.block;

import net.coreprotect.consumer.Queue;
import net.coreprotect.listener.player.PlayerDropItemListener;
import net.coreprotect.thread.CacheHandler;
import net.coreprotect.utility.WorldUtils;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.CampfireStartEvent;
import org.bukkit.inventory.ItemStack;

public final class CampfireStartListener
extends Queue
implements Listener {
    public static boolean useCampfireStartEvent = true;

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onCampfireStart(CampfireStartEvent event) {
        Block block = event.getBlock();
        Location location = block.getLocation();
        int worldId = WorldUtils.getWorldId(location.getWorld().getName());
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        String coordinates = x + "." + y + "." + z + "." + worldId + "." + block.getType().name();
        String user = "#entity";
        Object[] data = CacheHandler.interactCache.get(coordinates);
        if (data != null && data[1].equals(event.getSource())) {
            long oldTime;
            long newTime = System.currentTimeMillis();
            if (newTime - (oldTime = ((Long)data[0]).longValue()) < 20L) {
                user = (String)data[2];
            }
            CacheHandler.interactCache.remove(coordinates);
        }
        if (user.equals("#entity")) {
            return;
        }
        ItemStack itemStack = event.getSource().clone();
        itemStack.setAmount(1);
        PlayerDropItemListener.playerDropItem(event.getBlock().getLocation(), user, itemStack);
    }
}

