/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.database.rollback;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.database.rollback.RollbackUtil;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.io.BukkitObjectInputStream;

public class RollbackItemHandler {
    public static Object[] populateItemStack(ItemStack itemstack, byte[] metadata) {
        if (metadata != null) {
            try {
                ByteArrayInputStream metaByteStream = new ByteArrayInputStream(metadata);
                BukkitObjectInputStream metaObjectStream = new BukkitObjectInputStream((InputStream)metaByteStream);
                Object metaList = metaObjectStream.readObject();
                metaObjectStream.close();
                metaByteStream.close();
                return RollbackUtil.populateItemStack(itemstack, metaList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new Object[]{0, "", itemstack};
    }

    public static void sortContainerItems(PlayerInventory inventory, List<Integer> slots) {
        String materialName;
        ItemStack helmet;
        ItemStack chestplate;
        ItemStack leggings;
        ItemStack boots;
        if (slots.contains(0) && (boots = inventory.getBoots()) != null && !boots.getType().equals((Object)Material.AIR) && !boots.getType().name().contains("BOOTS")) {
            inventory.setBoots(new ItemStack(Material.AIR));
            inventory.addItem(new ItemStack[]{boots});
        }
        if (slots.contains(1) && (leggings = inventory.getLeggings()) != null && !leggings.getType().equals((Object)Material.AIR) && !leggings.getType().name().contains("LEGGINGS")) {
            inventory.setLeggings(new ItemStack(Material.AIR));
            inventory.addItem(new ItemStack[]{leggings});
        }
        if (slots.contains(2) && (chestplate = inventory.getChestplate()) != null && !chestplate.getType().equals((Object)Material.AIR) && !chestplate.getType().name().contains("CHESTPLATE")) {
            inventory.setChestplate(new ItemStack(Material.AIR));
            inventory.addItem(new ItemStack[]{chestplate});
        }
        if (!(!slots.contains(3) || (helmet = inventory.getHelmet()) == null || helmet.getType().equals((Object)Material.AIR) || (materialName = helmet.getType().name()).contains("HELMET") || materialName.contains("SKULL") || materialName.endsWith("_HEAD"))) {
            inventory.setHelmet(new ItemStack(Material.AIR));
            inventory.addItem(new ItemStack[]{helmet});
        }
    }

    public static void updateItemCount(String userString, int increment) {
        int[] rollbackHashData = ConfigHandler.rollbackHash.get(userString);
        int itemCount = rollbackHashData[0];
        int blockCount = rollbackHashData[1];
        int entityCount = rollbackHashData[2];
        int scannedWorlds = rollbackHashData[4];
        ConfigHandler.rollbackHash.put(userString, new int[]{itemCount += increment, blockCount, entityCount, 0, scannedWorlds});
    }
}

