/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.database.rollback;

import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.coreprotect.CoreProtect;
import net.coreprotect.bukkit.BukkitAdapter;
import net.coreprotect.config.Config;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.consumer.Queue;
import net.coreprotect.database.Lookup;
import net.coreprotect.database.LookupConverter;
import net.coreprotect.database.rollback.RollbackComplete;
import net.coreprotect.database.rollback.RollbackProcessor;
import net.coreprotect.database.rollback.RollbackUtil;
import net.coreprotect.database.statement.UserStatement;
import net.coreprotect.language.Phrase;
import net.coreprotect.model.BlockGroup;
import net.coreprotect.thread.Scheduler;
import net.coreprotect.utility.Chat;
import net.coreprotect.utility.Color;
import net.coreprotect.utility.DatabaseUtils;
import net.coreprotect.utility.WorldUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Rollback
extends RollbackUtil {
    public static List<String[]> performRollbackRestore(Statement statement, CommandSender user, List<String> checkUuids, List<String> checkUsers, String timeString, List<Object> restrictList, Map<Object, Boolean> excludeList, List<String> excludeUserList, List<Integer> actionList, Location location, Integer[] radius, long startTime, long endTime, boolean restrictWorld, boolean lookup, boolean verbose, int rollbackType, int preview) {
        ArrayList<String[]> list = new ArrayList();
        try {
            long chunkKey;
            long timeStart = System.currentTimeMillis();
            List<Object> lookupList = new ArrayList();
            if (!(actionList.contains(4) || actionList.contains(5) || checkUsers.contains("#container"))) {
                lookupList = Lookup.performLookupRaw(statement, user, checkUuids, checkUsers, restrictList, excludeList, excludeUserList, actionList, location, radius, null, startTime, endTime, -1, -1, restrictWorld, lookup);
            }
            if (lookupList == null) {
                return null;
            }
            boolean ROLLBACK_ITEMS = false;
            ArrayList<Object> itemRestrictList = new ArrayList<Object>(restrictList);
            HashMap<Object, Boolean> itemExcludeList = new HashMap<Object, Boolean>(excludeList);
            if (actionList.contains(1)) {
                for (Object target : restrictList) {
                    if (!(target instanceof Material) || excludeList.containsKey(target) || !BlockGroup.CONTAINERS.contains(target)) continue;
                    ROLLBACK_ITEMS = true;
                    itemRestrictList.clear();
                    itemExcludeList.clear();
                    break;
                }
            }
            ArrayList<Object[]> itemList = new ArrayList();
            if (Config.getGlobal().ROLLBACK_ITEMS && !checkUsers.contains("#container") && (actionList.size() == 0 || actionList.contains(4) || ROLLBACK_ITEMS) && preview == 0) {
                ArrayList<Integer> itemActionList = new ArrayList<Integer>(actionList);
                if (!itemActionList.contains(4)) {
                    itemActionList.add(4);
                }
                itemExcludeList.entrySet().removeIf(entry -> Boolean.TRUE.equals(entry.getValue()));
                itemList = Lookup.performLookupRaw(statement, user, checkUuids, checkUsers, itemRestrictList, itemExcludeList, excludeUserList, itemActionList, location, radius, null, startTime, endTime, -1, -1, restrictWorld, lookup);
            }
            LinkedHashSet<Integer> worldList = new LinkedHashSet<Integer>();
            TreeMap<Long, Integer> chunkList = new TreeMap<Long, Integer>();
            HashMap dataList = new HashMap();
            HashMap itemDataList = new HashMap();
            boolean inventoryRollback = actionList.contains(11);
            int worldId = -1;
            int worldMin = 0;
            int worldMax = 2032;
            for (int listC = 0; listC < 2; ++listC) {
                List<Object> scanList = lookupList;
                if (listC == 1) {
                    scanList = itemList;
                }
                for (Object[] objectArray : scanList) {
                    int userId = (Integer)objectArray[2];
                    int n = (Integer)objectArray[3];
                    int rowY = (Integer)objectArray[4];
                    int rowZ = (Integer)objectArray[5];
                    int rowWorldId = (Integer)objectArray[10];
                    int chunkX = n >> 4;
                    int chunkZ = rowZ >> 4;
                    long l = chunkKey = inventoryRollback ? 0L : (long)chunkX & 0xFFFFFFFFL | ((long)chunkZ & 0xFFFFFFFFL) << 32;
                    if (rowWorldId != worldId) {
                        String world = WorldUtils.getWorldName(rowWorldId);
                        World bukkitWorld = Bukkit.getServer().getWorld(world);
                        if (bukkitWorld != null) {
                            worldMin = BukkitAdapter.ADAPTER.getMinHeight(bukkitWorld);
                            worldMax = bukkitWorld.getMaxHeight();
                        }
                    }
                    if (chunkList.get(chunkKey) == null) {
                        int distance = 0;
                        if (location != null) {
                            distance = (int)Math.sqrt(Math.pow((Integer)objectArray[3] - location.getBlockX(), 2.0) + Math.pow((Integer)objectArray[5] - location.getBlockZ(), 2.0));
                        }
                        chunkList.put(chunkKey, distance);
                    }
                    if (ConfigHandler.playerIdCacheReversed.get(userId) == null) {
                        UserStatement.loadName(statement.getConnection(), userId);
                    }
                    HashMap modifyList = dataList;
                    if (listC == 1) {
                        modifyList = itemDataList;
                    }
                    if (modifyList.get(rowWorldId) == null) {
                        dataList.put(rowWorldId, new HashMap());
                        itemDataList.put(rowWorldId, new HashMap());
                        worldList.add(rowWorldId);
                    }
                    if (((HashMap)modifyList.get(rowWorldId)).get(chunkKey) == null) {
                        ((HashMap)dataList.get(rowWorldId)).put(chunkKey, new ArrayList());
                        ((HashMap)itemDataList.get(rowWorldId)).put(chunkKey, new ArrayList());
                    }
                    ((ArrayList)((HashMap)modifyList.get(rowWorldId)).get(chunkKey)).add(objectArray);
                }
            }
            if (rollbackType == 1) {
                Iterator dlIterator = dataList.entrySet().iterator();
                while (dlIterator.hasNext()) {
                    for (ArrayList arrayList : ((HashMap)dlIterator.next().getValue()).values()) {
                        Collections.reverse(arrayList);
                    }
                }
                dlIterator = itemDataList.entrySet().iterator();
                while (dlIterator.hasNext()) {
                    for (ArrayList arrayList : ((HashMap)dlIterator.next().getValue()).values()) {
                        Collections.reverse(arrayList);
                    }
                }
            }
            Integer chunkCount = 0;
            String userString = "#server";
            if (user != null) {
                userString = user.getName();
                if (verbose && preview == 0 && !actionList.contains(11)) {
                    Integer n = chunkList.size();
                    Chat.sendMessage(user, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_CHUNKS_FOUND, n.toString(), n == 1 ? "{1}" : "{2}"));
                }
            }
            if (preview == 0) {
                if (actionList.contains(11)) {
                    ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
                    ArrayList<Object[]> inventoryList = new ArrayList<Object[]>();
                    ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>();
                    for (Object[] data : itemList) {
                        int table = (Integer)data[14];
                        if (table == 2) {
                            inventoryList.add(data);
                            continue;
                        }
                        if (table == 1) {
                            arrayList2.add(data);
                            continue;
                        }
                        arrayList.add(data);
                    }
                    Queue.queueRollbackUpdate(userString, location, inventoryList, 27, rollbackType);
                    Queue.queueRollbackUpdate(userString, location, arrayList2, 28, rollbackType);
                    Queue.queueRollbackUpdate(userString, location, arrayList, 29, rollbackType);
                } else {
                    Queue.queueRollbackUpdate(userString, location, lookupList, 7, rollbackType);
                    Queue.queueRollbackUpdate(userString, location, itemList, 8, rollbackType);
                }
            }
            ConfigHandler.rollbackHash.put(userString, new int[]{0, 0, 0, 0, 0});
            String string = userString;
            for (Map.Entry entry2 : DatabaseUtils.entriesSortedByValues(chunkList)) {
                int n;
                World bukkitRollbackWorld;
                Integer rowY = chunkCount;
                chunkCount = chunkCount + 1;
                int itemCount = 0;
                int blockCount = 0;
                int entityCount = 0;
                int scannedWorldData = 0;
                int[] rollbackHashData = ConfigHandler.rollbackHash.get(string);
                itemCount = rollbackHashData[0];
                blockCount = rollbackHashData[1];
                entityCount = rollbackHashData[2];
                scannedWorldData = rollbackHashData[4];
                chunkKey = (Long)entry2.getKey();
                int finalChunkX = (int)chunkKey;
                int finalChunkZ = (int)(chunkKey >> 32);
                CommandSender finalUser = user;
                HashMap<Integer, World> worldMap = new HashMap<Integer, World>();
                Iterator<Object> iterator = worldList.iterator();
                while (iterator.hasNext()) {
                    int n2 = (Integer)iterator.next();
                    String rollbackWorld = WorldUtils.getWorldName(n2);
                    if (rollbackWorld.length() == 0 || (bukkitRollbackWorld = Bukkit.getServer().getWorld(rollbackWorld)) == null) continue;
                    worldMap.put(n2, bukkitRollbackWorld);
                }
                ConfigHandler.rollbackHash.put(string, new int[]{itemCount, blockCount, entityCount, 0, scannedWorldData});
                for (Map.Entry entry3 : worldMap.entrySet()) {
                    Integer rollbackWorldId = (Integer)entry3.getKey();
                    bukkitRollbackWorld = (World)entry3.getValue();
                    Location chunkLocation = new Location(bukkitRollbackWorld, (double)(finalChunkX << 4), 0.0, (double)(finalChunkZ << 4));
                    HashMap finalBlockList = (HashMap)dataList.get(rollbackWorldId);
                    HashMap finalItemList = (HashMap)itemDataList.get(rollbackWorldId);
                    Scheduler.scheduleSyncDelayedTask(CoreProtect.getInstance(), () -> {
                        ArrayList<Object[]> blockData = finalBlockList != null ? finalBlockList.getOrDefault(chunkKey, new ArrayList()) : new ArrayList<Object[]>();
                        ArrayList<Object[]> itemData = finalItemList != null ? finalItemList.getOrDefault(chunkKey, new ArrayList()) : new ArrayList<Object[]>();
                        RollbackProcessor.processChunk(finalChunkX, finalChunkZ, chunkKey, blockData, itemData, rollbackType, preview, finalUserString, finalUser instanceof Player ? (Player)finalUser : null, bukkitRollbackWorld, inventoryRollback);
                    }, chunkLocation, 0);
                }
                rollbackHashData = ConfigHandler.rollbackHash.get(string);
                int next = rollbackHashData[3];
                int n3 = rollbackHashData[4];
                int sleepTime = 0;
                boolean abort = false;
                while (next == 0 || n < worldMap.size()) {
                    if (preview == 1) {
                        ++sleepTime;
                        Thread.sleep(1L);
                    } else {
                        sleepTime += 5;
                        Thread.sleep(5L);
                    }
                    rollbackHashData = ConfigHandler.rollbackHash.get(string);
                    next = rollbackHashData[3];
                    n = rollbackHashData[4];
                    if (sleepTime <= 300000) continue;
                    abort = true;
                    break;
                }
                if (abort || next == 2) {
                    Chat.console(Phrase.build(Phrase.ROLLBACK_ABORTED, new String[0]));
                    break;
                }
                rollbackHashData = ConfigHandler.rollbackHash.get(string);
                itemCount = rollbackHashData[0];
                blockCount = rollbackHashData[1];
                entityCount = rollbackHashData[2];
                ConfigHandler.rollbackHash.put(string, new int[]{itemCount, blockCount, entityCount, 0, 0});
                if (!verbose || user == null || preview != 0 || actionList.contains(11)) continue;
                Integer chunks = chunkList.size();
                Chat.sendMessage(user, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_CHUNKS_MODIFIED, chunkCount.toString(), chunks.toString(), chunks == 1 ? "{1}" : "{2}"));
            }
            chunkList.clear();
            dataList.clear();
            itemDataList.clear();
            int[] rollbackHashData = ConfigHandler.rollbackHash.get(string);
            int n = rollbackHashData[0];
            int blockCount = rollbackHashData[1];
            int entityCount = rollbackHashData[2];
            long timeFinish = System.currentTimeMillis();
            double totalSeconds = (double)(timeFinish - timeStart) / 1000.0;
            if (user != null) {
                RollbackComplete.output(user, location, checkUsers, restrictList, excludeList, excludeUserList, actionList, timeString, chunkCount, totalSeconds, n, blockCount, entityCount, rollbackType, radius, verbose, restrictWorld, preview);
            }
            list = LookupConverter.convertRawLookup(statement, lookupList);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

