/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.command.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.coreprotect.language.Phrase;
import net.coreprotect.model.BlockGroup;
import net.coreprotect.utility.Chat;
import net.coreprotect.utility.Color;
import net.coreprotect.utility.EntityUtils;
import net.coreprotect.utility.MaterialUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;

public class MaterialParser {
    public static List<Object> parseRestricted(CommandSender player, String[] inputArguments, List<Integer> argAction) {
        String[] argumentArray = (String[])inputArguments.clone();
        ArrayList<Object> restricted = new ArrayList<Object>();
        int count = 0;
        int next = 0;
        for (String argument : argumentArray) {
            if (count > 0) {
                argument = argument.trim().toLowerCase(Locale.ROOT);
                argument = argument.replaceAll("\\\\", "");
                if ((argument = argument.replaceAll("'", "")).equals("i:") || argument.equals("include:") || argument.equals("item:") || argument.equals("items:") || argument.equals("b:") || argument.equals("block:") || argument.equals("blocks:")) {
                    next = 4;
                } else if (next == 4 || argument.startsWith("i:") || argument.startsWith("include:") || argument.startsWith("item:") || argument.startsWith("items:") || argument.startsWith("b:") || argument.startsWith("block:") || argument.startsWith("blocks:")) {
                    argument = argument.replaceAll("include:", "");
                    argument = argument.replaceAll("i:", "");
                    argument = argument.replaceAll("items:", "");
                    argument = argument.replaceAll("item:", "");
                    argument = argument.replaceAll("blocks:", "");
                    argument = argument.replaceAll("block:", "");
                    if ((argument = argument.replaceAll("b:", "")).contains(",")) {
                        String[] i2;
                        for (String i3 : i2 = argument.split(",")) {
                            if (MaterialParser.checkTags(i3, restricted)) continue;
                            Material i3_material = MaterialUtils.getType(i3);
                            if (i3_material != null && (i3_material.isBlock() || argAction.contains(4))) {
                                restricted.add(i3_material);
                                continue;
                            }
                            EntityType i3_entity = EntityUtils.getEntityType(i3);
                            if (i3_entity != null) {
                                restricted.add(i3_entity);
                                continue;
                            }
                            if (i3_material != null) {
                                restricted.add(i3_material);
                                continue;
                            }
                            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.INVALID_INCLUDE, i3));
                            return null;
                        }
                        next = argument.endsWith(",") ? 4 : 0;
                    } else {
                        if (!MaterialParser.checkTags(argument, restricted)) {
                            Material material = MaterialUtils.getType(argument);
                            if (material != null && (material.isBlock() || argAction.contains(4))) {
                                restricted.add(material);
                            } else {
                                EntityType entityType = EntityUtils.getEntityType(argument);
                                if (entityType != null) {
                                    restricted.add(entityType);
                                } else if (material != null) {
                                    restricted.add(material);
                                } else {
                                    Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.INVALID_INCLUDE, argument));
                                    return null;
                                }
                            }
                        }
                        next = 0;
                    }
                } else {
                    next = 0;
                }
            }
            ++count;
        }
        return restricted;
    }

    public static Map<Object, Boolean> parseExcluded(CommandSender player, String[] inputArguments, List<Integer> argAction) {
        String[] argumentArray = (String[])inputArguments.clone();
        HashMap<Object, Boolean> excluded = new HashMap<Object, Boolean>();
        int count = 0;
        int next = 0;
        for (String argument : argumentArray) {
            if (count > 0) {
                argument = argument.trim().toLowerCase(Locale.ROOT);
                argument = argument.replaceAll("\\\\", "");
                if ((argument = argument.replaceAll("'", "")).equals("e:") || argument.equals("exclude:")) {
                    next = 5;
                } else if (next == 5 || argument.startsWith("e:") || argument.startsWith("exclude:")) {
                    argument = argument.replaceAll("exclude:", "");
                    if ((argument = argument.replaceAll("e:", "")).contains(",")) {
                        String[] i2;
                        for (String i3 : i2 = argument.split(",")) {
                            if (MaterialParser.checkTags(i3, excluded)) continue;
                            Material i3_material = MaterialUtils.getType(i3);
                            if (i3_material != null && (i3_material.isBlock() || argAction.contains(4))) {
                                excluded.put(i3_material, false);
                                continue;
                            }
                            EntityType i3_entity = EntityUtils.getEntityType(i3);
                            if (i3_entity != null) {
                                excluded.put(i3_entity, false);
                                continue;
                            }
                            if (i3_material == null) continue;
                            excluded.put(i3_material, false);
                        }
                        next = argument.endsWith(",") ? 5 : 0;
                    } else {
                        if (!MaterialParser.checkTags(argument, excluded)) {
                            Material iMaterial = MaterialUtils.getType(argument);
                            if (iMaterial != null && (iMaterial.isBlock() || argAction.contains(4))) {
                                excluded.put(iMaterial, false);
                            } else {
                                EntityType iEntity = EntityUtils.getEntityType(argument);
                                if (iEntity != null) {
                                    excluded.put(iEntity, false);
                                } else if (iMaterial != null) {
                                    excluded.put(iMaterial, false);
                                }
                            }
                        }
                        next = 0;
                    }
                } else {
                    next = 0;
                }
            }
            ++count;
        }
        return excluded;
    }

    public static Map<String, Set<Material>> getTags() {
        HashMap<String, Set<Material>> tagMap = new HashMap<String, Set<Material>>();
        tagMap.put("#button", BlockGroup.BUTTONS);
        tagMap.put("#container", BlockGroup.CONTAINERS);
        tagMap.put("#door", BlockGroup.DOORS);
        tagMap.put("#natural", BlockGroup.NATURAL_BLOCKS);
        tagMap.put("#pressure_plate", BlockGroup.PRESSURE_PLATES);
        tagMap.put("#shulker_box", BlockGroup.SHULKER_BOXES);
        return tagMap;
    }

    public static boolean checkTags(String argument) {
        return MaterialParser.getTags().containsKey(argument);
    }

    public static boolean checkTags(String argument, Map<Object, Boolean> list) {
        for (Map.Entry<String, Set<Material>> entry : MaterialParser.getTags().entrySet()) {
            String tag = entry.getKey();
            Set<Material> materials = entry.getValue();
            if (!argument.equals(tag)) continue;
            for (Material block : materials) {
                list.put(block, false);
            }
            return true;
        }
        return false;
    }

    public static boolean checkTags(String argument, List<Object> list) {
        for (Map.Entry<String, Set<Material>> entry : MaterialParser.getTags().entrySet()) {
            String tag = entry.getKey();
            Set<Material> materials = entry.getValue();
            if (!argument.equals(tag)) continue;
            list.addAll(materials);
            return true;
        }
        return false;
    }

    public static boolean isBlockOrEntity(String argument) {
        boolean isBlock = false;
        if (MaterialParser.checkTags(argument)) {
            isBlock = true;
        } else {
            Material material = MaterialUtils.getType(argument);
            if (material != null) {
                isBlock = true;
            } else {
                EntityType entityType = EntityUtils.getEntityType(argument);
                if (entityType != null) {
                    isBlock = true;
                }
            }
        }
        return isBlock;
    }
}

