/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.command;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.coreprotect.command.CommandParser;
import net.coreprotect.command.lookup.BlockLookupThread;
import net.coreprotect.command.lookup.ChestTransactionLookupThread;
import net.coreprotect.command.lookup.StandardLookupThread;
import net.coreprotect.config.Config;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.language.Phrase;
import net.coreprotect.utility.Chat;
import net.coreprotect.utility.ChatMessage;
import net.coreprotect.utility.Color;
import net.coreprotect.utility.WorldUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class LookupCommand {
    public static void runCommand(CommandSender player, Command command, boolean permission, String[] args) {
        Object[] lookupThrottle;
        int resultc = args.length;
        args = CommandParser.parsePage(args);
        Location lo = CommandParser.parseLocation(player, args);
        List<String> argUsers = CommandParser.parseUsers(args);
        Integer[] argRadius = CommandParser.parseRadius(args, player, lo);
        int argNoisy = CommandParser.parseNoisy(args);
        List<Integer> argAction = CommandParser.parseAction(args);
        List<Object> argBlocks = CommandParser.parseRestricted(player, args, argAction);
        Map<Object, Boolean> argExclude = CommandParser.parseExcluded(player, args, argAction);
        List<String> argExcludeUsers = CommandParser.parseExcludedUsers(player, args);
        String ts = CommandParser.parseTimeString(args);
        long[] argTime = CommandParser.parseTime(args);
        long startTime = argTime[0];
        long endTime = argTime[1];
        int argWid = CommandParser.parseWorld(args, true, true);
        int parseRows = CommandParser.parseRows(args);
        boolean count = CommandParser.parseCount(args);
        boolean worldedit = CommandParser.parseWorldEdit(args);
        boolean forceglobal = CommandParser.parseForceGlobal(args);
        boolean pageLookup = false;
        if (argBlocks == null || argExclude == null || argExcludeUsers == null) {
            return;
        }
        if (args[0].toLowerCase(Locale.ROOT).equals("page") && (args.length != 2 || !args[1].equals(args[1].replaceAll("[^0-9]", "")))) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.MISSING_PARAMETERS, Color.WHITE, "/co page <page>"));
            return;
        }
        int argExcluded = argExclude.size();
        int argRestricted = argBlocks.size();
        boolean hasBlock = false;
        boolean hasEntity = false;
        for (Object arg : argBlocks) {
            if (arg instanceof Material) {
                hasBlock = true;
                continue;
            }
            if (!(arg instanceof EntityType)) continue;
            hasEntity = true;
            if (argAction.size() == 0) {
                argAction.add(3);
                continue;
            }
            if (argAction.contains(3)) continue;
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.INVALID_INCLUDE_COMBO, new String[0]));
            return;
        }
        for (Object arg : argExclude.keySet()) {
            if (arg instanceof Material) {
                hasBlock = true;
                continue;
            }
            if (!(arg instanceof EntityType)) continue;
            hasEntity = true;
            if (argAction.size() == 0) {
                argAction.add(3);
                continue;
            }
            if (argAction.contains(3)) continue;
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.INVALID_INCLUDE_COMBO, new String[0]));
            return;
        }
        if (hasBlock && hasEntity) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.INVALID_INCLUDE_COMBO, new String[0]));
            return;
        }
        if (argWid == -1) {
            String worldName = CommandParser.parseWorldName(args, true);
            Chat.sendMessage(player, new ChatMessage(Phrase.build(Phrase.WORLD_NOT_FOUND, worldName)).build());
            return;
        }
        int type = 0;
        if (ConfigHandler.lookupType.get(player.getName()) != null) {
            type = ConfigHandler.lookupType.get(player.getName());
        }
        if (type == 0 && resultc > 1) {
            type = 4;
        } else if (resultc > 2) {
            type = 4;
        } else if (resultc > 1) {
            pageLookup = true;
            String dat = args[1];
            if (dat.contains(":")) {
                String[] split = dat.split(":");
                String check1 = split[0].replaceAll("[^a-zA-Z_]", "");
                String check2 = "";
                if (split.length > 1) {
                    check2 = split[1].replaceAll("[^a-zA-Z_]", "");
                }
                if (check1.length() > 0 || check2.length() > 0) {
                    type = 4;
                    pageLookup = false;
                }
            } else {
                String check1 = dat.replaceAll("[^a-zA-Z_]", "");
                if (check1.length() > 0) {
                    type = 4;
                    pageLookup = false;
                }
            }
        }
        if (argAction.contains(6) || argAction.contains(7) || argAction.contains(8) || argAction.contains(9) || argAction.contains(10)) {
            pageLookup = true;
        }
        if (!(permission || pageLookup && player.hasPermission("coreprotect.inspect"))) {
            Chat.sendMessage(player, new ChatMessage(Phrase.build(Phrase.NO_PERMISSION, new String[0])).build());
            return;
        }
        if (ConfigHandler.converterRunning) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.UPGRADE_IN_PROGRESS, new String[0]));
            return;
        }
        if (ConfigHandler.purgeRunning) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.PURGE_IN_PROGRESS, new String[0]));
            return;
        }
        if (resultc < 2) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.MISSING_PARAMETERS, "/co l <params>"));
            return;
        }
        if (argAction.contains(-1)) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.INVALID_ACTION, new String[0]));
            return;
        }
        if (worldedit && argRadius == null) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.INVALID_SELECTION, "WorldEdit"));
            return;
        }
        if (argRadius != null && argRadius[0] == -1) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.INVALID_RADIUS, new String[0]));
            return;
        }
        if (ConfigHandler.lookupThrottle.get(player.getName()) != null && (((Boolean)(lookupThrottle = ConfigHandler.lookupThrottle.get(player.getName()))[0]).booleanValue() || System.currentTimeMillis() - (Long)lookupThrottle[1] < 50L)) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.DATABASE_BUSY, new String[0]));
            return;
        }
        boolean allPermission = false;
        if (args[0].equals("near") && player.hasPermission("coreprotect.lookup.near")) {
            allPermission = true;
        }
        if (!allPermission) {
            if (!pageLookup && (argAction.size() == 0 || argAction.size() == 1 && (argAction.contains(0) || argAction.contains(1))) && !player.hasPermission("coreprotect.lookup.block")) {
                Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.NO_PERMISSION, new String[0]));
                return;
            }
            if (argAction.contains(2) && !player.hasPermission("coreprotect.lookup.click")) {
                Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.NO_PERMISSION, new String[0]));
                return;
            }
            if (argAction.contains(3) && !player.hasPermission("coreprotect.lookup.kill")) {
                Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.NO_PERMISSION, new String[0]));
                return;
            }
            if (argAction.contains(4) && !argAction.contains(11) && !player.hasPermission("coreprotect.lookup.container")) {
                Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.NO_PERMISSION, new String[0]));
                return;
            }
            if (argAction.contains(6) && !player.hasPermission("coreprotect.lookup.chat")) {
                Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.NO_PERMISSION, new String[0]));
                return;
            }
            if (argAction.contains(7) && !player.hasPermission("coreprotect.lookup.command")) {
                Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.NO_PERMISSION, new String[0]));
                return;
            }
            if (argAction.contains(8) && !player.hasPermission("coreprotect.lookup.session")) {
                Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.NO_PERMISSION, new String[0]));
                return;
            }
            if (argAction.contains(9) && !player.hasPermission("coreprotect.lookup.username")) {
                Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.NO_PERMISSION, new String[0]));
                return;
            }
            if (argAction.contains(10) && !player.hasPermission("coreprotect.lookup.sign")) {
                Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.NO_PERMISSION, new String[0]));
                return;
            }
            if (argAction.contains(11) && !argAction.contains(4) && !player.hasPermission("coreprotect.lookup.item")) {
                Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.NO_PERMISSION, new String[0]));
                return;
            }
            if (argAction.contains(4) && argAction.contains(11) && !player.hasPermission("coreprotect.lookup.inventory")) {
                Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.NO_PERMISSION, new String[0]));
                return;
            }
        }
        if (argAction.contains(6) || argAction.contains(7) || argAction.contains(8) || argAction.contains(9) || argAction.contains(10)) {
            if (argAction.contains(9) && (argRadius != null || argWid > 0 || worldedit)) {
                Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.INCOMPATIBLE_ACTION, "r:"));
                return;
            }
            if (argBlocks.size() > 0) {
                Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.INCOMPATIBLE_ACTION, "i:"));
                return;
            }
            if (argExclude.size() > 0) {
                Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.INCOMPATIBLE_ACTION, "e:"));
                return;
            }
        }
        if (!(startTime > 0L || pageLookup || type != 4 || argBlocks.size() <= 0 && argUsers.size() <= 0)) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.MISSING_LOOKUP_TIME, "{1}"));
            return;
        }
        if (argAction.contains(4) && argAction.contains(11)) {
            if (argUsers.size() == 0) {
                Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.MISSING_ACTION_USER, new String[0]));
                return;
            }
            argExclude.put(Material.FIRE, false);
            argExclude.put(Material.WATER, false);
            argExclude.put(Material.FARMLAND, false);
            argExcludeUsers.add("#hopper");
        }
        if (type == 1) {
            String[] data;
            boolean defaultRe = true;
            int p = 0;
            int re = 7;
            if (parseRows > 0) {
                re = parseRows;
            }
            if (resultc > 1) {
                int pa;
                String pages = args[1];
                if (pages.contains(":")) {
                    int r;
                    data = pages.split(":");
                    pages = data[0];
                    String results = "";
                    if (data.length > 1) {
                        results = data[1];
                    }
                    if ((results = results.replaceAll("[^0-9]", "")).length() > 0 && results.length() < 10 && (r = Integer.parseInt(results)) > 0) {
                        re = r;
                        defaultRe = false;
                    }
                }
                if ((pages = pages.replaceAll("[^0-9]", "")).length() > 0 && pages.length() < 10 && (pa = Integer.parseInt(pages)) > 0) {
                    p = pa;
                }
            }
            if (re > 1000) {
                re = 1000;
            }
            if (re > 100 && !(player instanceof ConsoleCommandSender)) {
                re = 100;
            }
            if (p <= 0) {
                p = 1;
            }
            String lcommand = ConfigHandler.lookupCommand.get(player.getName());
            data = lcommand.split("\\.");
            int x = Integer.parseInt(data[0]);
            int y = Integer.parseInt(data[1]);
            int z = Integer.parseInt(data[2]);
            int wid = Integer.parseInt(data[3]);
            int x2 = Integer.parseInt(data[4]);
            int y2 = Integer.parseInt(data[5]);
            int z2 = Integer.parseInt(data[6]);
            if (defaultRe) {
                re = Integer.parseInt(data[7]);
            }
            String bc = x + "." + y + "." + z + "." + wid + "." + x2 + "." + y2 + "." + z2 + "." + re;
            ConfigHandler.lookupCommand.put(player.getName(), bc);
            String world = WorldUtils.getWorldName(wid);
            double dx = 0.5 * (double)(x + x2);
            double dy = 0.5 * (double)(y + y2);
            double dz = 0.5 * (double)(z + z2);
            Location location = new Location(Bukkit.getServer().getWorld(world), dx, dy, dz);
            ChestTransactionLookupThread runnable = new ChestTransactionLookupThread(player, command, location, p, re);
            Thread thread = new Thread(runnable);
            thread.start();
        } else if (type == 2 || type == 3 || type == 7 || type == 8) {
            boolean defaultRe = true;
            int page = 1;
            int re = 7;
            if (parseRows > 0) {
                re = parseRows;
            }
            if (resultc > 1) {
                int p;
                String pages = args[1];
                if (pages.contains(":")) {
                    int r;
                    String[] data = pages.split(":");
                    pages = data[0];
                    String results = "";
                    if (data.length > 1) {
                        results = data[1];
                    }
                    if ((results = results.replaceAll("[^0-9]", "")).length() > 0 && results.length() < 10 && (r = Integer.parseInt(results)) > 0) {
                        re = r;
                        defaultRe = false;
                    }
                }
                if ((pages = pages.replaceAll("[^0-9]", "")).length() > 0 && pages.length() < 10 && (p = Integer.parseInt(pages)) > 0) {
                    page = p;
                }
            }
            if (re > 1000) {
                re = 1000;
            }
            if (re > 100 && !(player instanceof ConsoleCommandSender)) {
                re = 100;
            }
            String lcommand = ConfigHandler.lookupCommand.get(player.getName());
            String[] data = lcommand.split("\\.");
            int x = Integer.parseInt(data[0]);
            int y = Integer.parseInt(data[1]);
            int z = Integer.parseInt(data[2]);
            int wid = Integer.parseInt(data[3]);
            int lookupType = Integer.parseInt(data[4]);
            if (defaultRe) {
                re = Integer.parseInt(data[5]);
            }
            String bc = x + "." + y + "." + z + "." + wid + "." + lookupType + "." + re;
            ConfigHandler.lookupCommand.put(player.getName(), bc);
            String world = WorldUtils.getWorldName(wid);
            Block block = Bukkit.getServer().getWorld(world).getBlockAt(x, y, z);
            BlockState blockState = block.getState();
            BlockLookupThread runnable = new BlockLookupThread(player, command, block, blockState, page, re, type);
            Thread thread = new Thread(runnable);
            thread.start();
        } else if (type == 4 || type == 5) {
            boolean defaultRe = true;
            int pa = 1;
            int re = 4;
            if (argAction.contains(6) || argAction.contains(7) || argAction.contains(9) || argAction.contains(4) && argAction.contains(11)) {
                re = 7;
            }
            if (parseRows > 0) {
                re = parseRows;
            }
            if (type == 5 && resultc > 1) {
                int p;
                String pages = args[1];
                if (pages.contains(":")) {
                    int r;
                    String[] data = pages.split(":");
                    pages = data[0];
                    String results = "";
                    if (data.length > 1) {
                        results = data[1];
                    }
                    if ((results = results.replaceAll("[^0-9]", "")).length() > 0 && results.length() < 10 && (r = Integer.parseInt(results)) > 0) {
                        re = r;
                        defaultRe = false;
                    }
                }
                if ((pages = pages.replaceAll("[^0-9]", "")).length() > 0 && pages.length() < 10 && (p = Integer.parseInt(pages)) > 0) {
                    pa = p;
                }
            }
            if (re > 1000) {
                re = 1000;
            }
            if (re > 100 && !(player instanceof ConsoleCommandSender)) {
                re = 100;
            }
            boolean g = true;
            if (argUsers.contains("#global") && argRadius == null) {
                g = false;
            }
            if (g && (pageLookup || argBlocks.size() > 0 || argUsers.size() > 0 || argUsers.size() == 0 && argRadius != null)) {
                int radiusValue;
                Integer MAX_RADIUS = Config.getGlobal().MAX_RADIUS;
                if (argRadius != null && (radiusValue = argRadius[0].intValue()) > MAX_RADIUS && MAX_RADIUS > 0) {
                    Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.MAXIMUM_RADIUS, MAX_RADIUS.toString(), "{1}"));
                    Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.GLOBAL_LOOKUP, new String[0]));
                    return;
                }
                if (argUsers.size() == 0) {
                    argUsers.add("#global");
                }
                List<String> rollbackusers = argUsers;
                int c = 0;
                for (String ruser : rollbackusers) {
                    if (Bukkit.getServer() != null) {
                        List players = Bukkit.getServer().matchPlayer(ruser);
                        for (Player p : players) {
                            if (!p.getName().equalsIgnoreCase(ruser)) continue;
                            rollbackusers.set(c, p.getName());
                        }
                    }
                    ++c;
                    if (!argAction.contains(4) || !argAction.contains(11) || !ruser.startsWith("#")) continue;
                    Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.INVALID_USERNAME, ruser));
                    return;
                }
                long timeStart = -1L;
                long timeEnd = 0L;
                int x = 0;
                int y = 0;
                int z = 0;
                int wid = 0;
                if (type == 5) {
                    String lcommand = ConfigHandler.lookupCommand.get(player.getName());
                    String[] data = lcommand.split("\\.");
                    x = Integer.parseInt(data[0]);
                    y = Integer.parseInt(data[1]);
                    z = Integer.parseInt(data[2]);
                    wid = Integer.parseInt(data[3]);
                    timeStart = Long.parseLong(data[4]);
                    timeEnd = Long.parseLong(data[5]);
                    argNoisy = Integer.parseInt(data[6]);
                    argExcluded = Integer.parseInt(data[7]);
                    argRestricted = Integer.parseInt(data[8]);
                    argWid = Integer.parseInt(data[9]);
                    if (defaultRe) {
                        re = Integer.parseInt(data[10]);
                    }
                    rollbackusers = ConfigHandler.lookupUlist.get(player.getName());
                    argBlocks = ConfigHandler.lookupBlist.get(player.getName());
                    argExclude = ConfigHandler.lookupElist.get(player.getName());
                    argExcludeUsers = ConfigHandler.lookupEUserlist.get(player.getName());
                    argAction = ConfigHandler.lookupAlist.get(player.getName());
                    argRadius = ConfigHandler.lookupRadius.get(player.getName());
                    ts = ConfigHandler.lookupTime.get(player.getName());
                    startTime = 1L;
                    endTime = 0L;
                } else {
                    if (lo != null) {
                        x = lo.getBlockX();
                        z = lo.getBlockZ();
                        if (lo.getWorld() != null) {
                            wid = WorldUtils.getWorldId(lo.getWorld().getName());
                        }
                    }
                    if (rollbackusers.size() == 1 && rollbackusers.contains("#global") && argAction.contains(9)) {
                        Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.MISSING_PARAMETERS, "/co l a:username u:<user>"));
                        return;
                    }
                    if (rollbackusers.contains("#container")) {
                        if (argAction.contains(6) || argAction.contains(7) || argAction.contains(8) || argAction.contains(9) || argAction.contains(10) || argAction.contains(11)) {
                            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.INVALID_USERNAME, "#container"));
                            return;
                        }
                        boolean valid = false;
                        if (ConfigHandler.lookupType.get(player.getName()) != null) {
                            int lookupType = ConfigHandler.lookupType.get(player.getName());
                            if (lookupType == 1) {
                                valid = true;
                            } else if (lookupType == 5 && ConfigHandler.lookupUlist.get(player.getName()).contains("#container")) {
                                valid = true;
                            }
                        }
                        if (valid) {
                            if (!player.hasPermission("coreprotect.lookup.container") && !allPermission) {
                                Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.NO_PERMISSION, new String[0]));
                                return;
                            }
                            String lcommand = ConfigHandler.lookupCommand.get(player.getName());
                            String[] data = lcommand.split("\\.");
                            x = Integer.parseInt(data[0]);
                            y = Integer.parseInt(data[1]);
                            z = Integer.parseInt(data[2]);
                            wid = Integer.parseInt(data[3]);
                            argAction.add(5);
                            argRadius = null;
                            argWid = 0;
                        } else {
                            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.INVALID_CONTAINER, new String[0]));
                            return;
                        }
                    }
                }
                try {
                    Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- \u00a7o" + Phrase.build(Phrase.LOOKUP_SEARCHING, new String[0]));
                    if (timeStart == -1L) {
                        timeStart = startTime <= 0L ? 0L : System.currentTimeMillis() / 1000L - startTime;
                        timeEnd = endTime <= 0L ? 0L : System.currentTimeMillis() / 1000L - endTime;
                    }
                    StandardLookupThread runnable = new StandardLookupThread(player, command, rollbackusers, argBlocks, argExclude, argExcludeUsers, argAction, argRadius, lo, x, y, z, wid, argWid, timeStart, timeEnd, argNoisy, argExcluded, argRestricted, pa, re, type, ts, count);
                    Thread thread = new Thread(runnable);
                    thread.start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                if (argUsers.size() == 0 && argBlocks.size() == 0 && (argWid > 0 || forceglobal)) {
                    Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.MISSING_LOOKUP_USER, "{1}"));
                    return;
                }
                if (argUsers.size() == 0 && argBlocks.size() == 0 && argRadius == null) {
                    Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.MISSING_LOOKUP_USER, "{2}"));
                    return;
                }
                Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.MISSING_PARAMETERS, "/co l <params>"));
            }
        } else {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.MISSING_PARAMETERS, "/co l <params>"));
        }
    }
}

